/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PVector;
import sms.Unimotion;

public class CAVEHUNTER
extends PApplet {
    int sectionNum = 20;
    int sectionCount;
    int sectionIndex;
    int prevSectionIndex;
    int obstacleNum = 10;
    int obstacleCount;
    int obstacleIndex;
    int pointNum = 10;
    int pointCount;
    int pointIndex;
    int collision = 0;
    int score = 0;
    boolean play = false;
    boolean go = false;
    float generalSpeed = 5.0f;
    CaveSection[] caveSections = new CaveSection[this.sectionNum];
    Obstacle01[] obstacles01 = new Obstacle01[this.obstacleNum];
    Point[] points = new Point[this.pointNum];
    Ship ship;
    Score gameScore;
    Start start;
    GameOver gameOver;
    StartScreen startScreen;
    float anschlussX;
    float anschlussYo;
    float anschlussYu;
    int sectionId;
    Minim minim;
    AudioPlayer gameSound;
    AudioPlayer introSound;
    AudioPlayer boom;
    AudioPlayer kasching;

    public void setup() {
        this.size(800, 450);
        this.background(0);
        this.smooth();
        this.frameRate(30.0f);
        this.startScreen = new StartScreen();
        this.minim = new Minim((PApplet)this);
        this.introSound = this.minim.loadFile("introSound.mp3", 512);
        this.introSound.play();
    }

    public void draw() {
        this.background(0);
        if (this.play) {
            this.start.update();
            this.generateCave();
            this.ship.update();
            this.gameScore.update();
            if (this.frameCount % 3 == 0 && !this.go) {
                ++this.score;
            }
            if (this.collision >= 5) {
                this.gameOver.update();
            }
        } else {
            this.startScreen.update();
        }
    }

    public void keyReleased() {
        if (this.key == '\uffff') {
            if (this.go && this.keyCode == 39) {
                this.reset();
            } else if (!this.play) {
                this.play = true;
                this.reset();
                this.introSound.close();
            }
        }
    }

    public void generateCave() {
        if (CAVEHUNTER.abs((float)this.caveSections[this.prevSectionIndex].pos) + (float)this.width >= this.anschlussX) {
            this.caveSections[this.sectionIndex] = new CaveSection(this.width, this.anschlussYo, this.anschlussYu, this.sectionId);
            this.generateObstacle(this.anschlussYo, this.anschlussYu);
            this.generatePoint(this.anschlussYo, this.anschlussYu);
            this.anschlussX = this.caveSections[this.sectionIndex].x2 - this.generalSpeed;
            this.anschlussYo = this.caveSections[this.sectionIndex].yo2;
            this.anschlussYu = this.caveSections[this.sectionIndex].yu2;
            ++this.sectionId;
            if (this.sectionCount < this.sectionNum) {
                ++this.sectionCount;
            }
            this.prevSectionIndex = this.sectionIndex++;
            if (this.sectionIndex >= this.sectionNum) {
                this.sectionIndex = 0;
            }
        }
        int n = 0;
        while (n < this.sectionCount) {
            this.caveSections[n].update();
            if (this.caveSections[n].hitTest() && this.collision == 0) {
                this.collision = 1;
            }
            ++n;
        }
        n = 0;
        while (n < this.obstacleCount) {
            this.obstacles01[n].update();
            ++n;
        }
        n = 0;
        while (n < this.pointCount) {
            this.points[n].update();
            ++n;
        }
    }

    public void generateObstacle(float f, float f2) {
        float f3 = this.random(10.0f);
        if (f2 - f > this.ship.sizeY + 10.0f && f3 > 5.0f) {
            this.obstacles01[this.obstacleIndex] = new Obstacle01(this.width, f, f2 - f);
            ++this.obstacleIndex;
            if (this.obstacleIndex >= this.obstacleNum) {
                this.obstacleIndex = 0;
            }
            if (this.obstacleCount < this.obstacleNum) {
                ++this.obstacleCount;
            }
        }
    }

    public void generatePoint(float f, float f2) {
        float f3 = this.random(10.0f);
        if (f3 > 5.0f) {
            this.points[this.pointIndex] = new Point(this.width, f, f2 - f);
            ++this.pointIndex;
            if (this.pointIndex >= this.obstacleNum) {
                this.pointIndex = 0;
            }
            if (this.pointCount < this.obstacleNum) {
                ++this.pointCount;
            }
        }
    }

    public float winkelBerechnung(float f, float f2, float f3, float f4, float f5, float f6) {
        PVector pVector = new PVector(f - f3, f2 - f4);
        PVector pVector2 = new PVector(-1.0f * pVector.y, pVector.x);
        float f7 = f3 + pVector2.x;
        float f8 = f4 + pVector2.y;
        float f9 = ((f7 - f3) * (f5 - f3) + (f8 - f4) * (f6 - f4)) / (CAVEHUNTER.dist((float)f3, (float)f4, (float)f7, (float)f8) * CAVEHUNTER.dist((float)f3, (float)f4, (float)f5, (float)f6));
        return f9;
    }

    public void explode(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        this.fill(255.0f, 0.0f, 0.0f);
        this.noStroke();
        this.beginShape();
        int n = 0;
        while (n < 12) {
            float f5 = n % 2 == 0 ? this.random(40.0f, 50.0f) : this.random(10.0f, 20.0f);
            float f6 = f3 + CAVEHUNTER.cos((float)CAVEHUNTER.radians((float)((float)n * this.random(28.0f, 32.0f)))) * f5;
            float f7 = f4 + CAVEHUNTER.sin((float)CAVEHUNTER.radians((float)((float)n * this.random(28.0f, 32.0f)))) * f5;
            this.vertex(f6, f7);
            ++n;
        }
        this.endShape(2);
        if (this.collision == 1) {
            this.boom = this.minim.loadFile("explode.mp3", 512);
            this.boom.play();
            this.gameSound.close();
        }
    }

    public void reset() {
        this.score = 0;
        this.collision = 0;
        this.go = false;
        this.obstacleCount = 0;
        this.obstacleIndex = 0;
        this.pointCount = 0;
        this.pointIndex = 0;
        this.sectionId = 0;
        this.sectionCount = 0;
        this.sectionIndex = 0;
        this.prevSectionIndex = 0;
        this.anschlussX = this.width;
        this.anschlussYo = this.height / 2 - 30;
        this.anschlussYu = this.height / 2 + 30;
        int[] nArray = Unimotion.getSMSArray();
        this.ship = new Ship(nArray);
        this.gameScore = new Score();
        this.start = new Start();
        this.gameOver = new GameOver();
        this.caveSections[this.sectionIndex] = new CaveSection(this.anschlussX, this.anschlussYo, this.anschlussYu, this.sectionId);
        this.anschlussX = this.caveSections[this.sectionIndex].x2 - this.generalSpeed;
        this.anschlussYo = this.caveSections[this.sectionIndex].yo2;
        this.anschlussYu = this.caveSections[this.sectionIndex].yu2;
        ++this.sectionId;
        ++this.sectionCount;
        ++this.sectionIndex;
        this.gameSound = this.minim.loadFile("bubbles.mp3", 512);
        this.boom = this.minim.loadFile("explode.mp3", 512);
        this.kasching = this.minim.loadFile("kasching.mp3", 512);
        this.gameSound.play();
        this.gameSound.loop(99);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--present", "--bgcolor=#666666", "--stop-color=#cccccc", "CAVEHUNTER"});
    }

    class CaveSection {
        int id;
        float pos;
        float x1;
        float x2;
        float yo1;
        float yo2;
        float yu1;
        float yu2;
        int farbe;
        boolean hitTest;
        float hitBorderO;
        float hitBorderU;
        float winkel;

        CaveSection(float f, float f2, float f3, int n) {
            this.x1 = f;
            this.yo1 = f2;
            this.yu1 = f3;
            this.id = n;
            this.x2 = this.x1 + CAVEHUNTER.this.random(100.0f, 150.0f);
            this.yo2 = this.yo1 + CAVEHUNTER.this.random(-50.0f, 50.0f);
            if (this.yo2 < 0.0f) {
                this.yo2 = 0.0f;
            }
            this.yu2 = this.yo2 + CAVEHUNTER.this.random(30.0f, 150.0f);
            if (this.yu2 > (float)CAVEHUNTER.this.height) {
                this.yo2 -= this.yu2 - (float)CAVEHUNTER.this.height;
                this.yu2 = CAVEHUNTER.this.height;
            }
            this.hitTest = false;
            this.hitBorderO = this.yo1 > this.yo2 ? this.yo1 : this.yo2;
            this.hitBorderU = this.yu1 < this.yu2 ? this.yu1 : this.yu2;
            this.farbe = 255;
        }

        public void positionieren() {
            this.pos -= CAVEHUNTER.this.generalSpeed;
        }

        public boolean hitTest() {
            if (CAVEHUNTER.this.ship.x - CAVEHUNTER.this.ship.sizeX / 2.0f >= this.pos + this.x1 && CAVEHUNTER.this.ship.x + CAVEHUNTER.this.ship.sizeX / 2.0f <= this.pos + this.x2) {
                if (CAVEHUNTER.this.ship.y - CAVEHUNTER.this.ship.sizeY / 2.0f < this.hitBorderO) {
                    this.winkel = this.yo1 > this.yo2 ? CAVEHUNTER.this.winkelBerechnung(this.pos + this.x2, this.yo2, this.pos + this.x1, this.yo1, CAVEHUNTER.this.ship.x - CAVEHUNTER.this.ship.sizeX / 2.0f, CAVEHUNTER.this.ship.y - CAVEHUNTER.this.ship.sizeY / 2.0f) : CAVEHUNTER.this.winkelBerechnung(this.pos + this.x1, this.yo1, this.pos + this.x2, this.yo2, CAVEHUNTER.this.ship.x + CAVEHUNTER.this.ship.sizeX / 2.0f, CAVEHUNTER.this.ship.y - CAVEHUNTER.this.ship.sizeY / 2.0f) * -1.0f;
                }
                if (CAVEHUNTER.this.ship.y + CAVEHUNTER.this.ship.sizeY / 2.0f > this.hitBorderU) {
                    this.winkel = this.yu1 < this.yu2 ? CAVEHUNTER.this.winkelBerechnung(CAVEHUNTER.this.ship.x - CAVEHUNTER.this.ship.sizeX / 2.0f, CAVEHUNTER.this.ship.y + CAVEHUNTER.this.ship.sizeY / 2.0f, this.pos + this.x1, this.yu1, this.pos + this.x2, this.yu2) : CAVEHUNTER.this.winkelBerechnung(this.pos + this.x1, this.yu1, this.pos + this.x2, this.yu2, CAVEHUNTER.this.ship.x + CAVEHUNTER.this.ship.sizeX / 2.0f, CAVEHUNTER.this.ship.y + CAVEHUNTER.this.ship.sizeY / 2.0f);
                }
                if (this.winkel < 0.0f && !this.hitTest) {
                    this.hitTest = true;
                }
            }
            return this.hitTest;
        }

        public void zeichnen() {
            CAVEHUNTER.this.noStroke();
            CAVEHUNTER.this.fill(this.farbe);
            CAVEHUNTER.this.quad(this.pos + this.x1, this.yo1, this.pos + this.x2, this.yo2, this.pos + this.x2, this.yu2, this.pos + this.x1, this.yu1);
        }

        public void update() {
            if (CAVEHUNTER.this.collision < 5) {
                this.positionieren();
            }
            this.zeichnen();
        }
    }

    class GameOver {
        PFont font;
        PFont fontScore;
        PFont fontReplay;
        boolean showReplay = false;

        GameOver() {
            this.font = CAVEHUNTER.this.loadFont("AndaleMono-60.vlw");
            this.fontScore = CAVEHUNTER.this.loadFont("AndaleMono-30.vlw");
            this.fontReplay = CAVEHUNTER.this.loadFont("AndaleMono-20.vlw");
        }

        public void zeichnen() {
            CAVEHUNTER.this.fill(255.0f, 0.0f, 0.0f);
            CAVEHUNTER.this.textFont(this.font);
            CAVEHUNTER.this.textAlign(3);
            CAVEHUNTER.this.text("GAME OVER", CAVEHUNTER.this.width / 2, CAVEHUNTER.this.height / 2 + 22);
            CAVEHUNTER.this.fill(0.0f, 255.0f, 0.0f);
            CAVEHUNTER.this.textFont(this.fontScore);
            CAVEHUNTER.this.textAlign(3);
            CAVEHUNTER.this.text("SCORE: " + CAVEHUNTER.this.score, CAVEHUNTER.this.width / 2, CAVEHUNTER.this.height / 2 + 70);
            if (CAVEHUNTER.this.frameCount % 30 == 0) {
                this.showReplay = !this.showReplay;
            }
            if (this.showReplay) {
                CAVEHUNTER.this.fill(114.0f, 0.0f, 255.0f, 150.0f);
                CAVEHUNTER.this.noStroke();
                CAVEHUNTER.this.rectMode(3);
                CAVEHUNTER.this.rect(CAVEHUNTER.this.width / 2, CAVEHUNTER.this.height / 2 + 114, 400.0f, 30.0f);
                CAVEHUNTER.this.fill(255);
                CAVEHUNTER.this.textFont(this.fontReplay);
                CAVEHUNTER.this.textAlign(3);
                CAVEHUNTER.this.text("* Press 'RIGHT' to play again! *", CAVEHUNTER.this.width / 2, CAVEHUNTER.this.height / 2 + 120);
            }
            if (!CAVEHUNTER.this.go) {
                CAVEHUNTER.this.go = true;
            }
        }

        public void update() {
            this.zeichnen();
        }
    }

    class Obstacle01 {
        float posX;
        float posY;
        float range;
        float speed;
        int dir;
        float x;
        float y;
        float angle;
        float s;

        Obstacle01(float f, float f2, float f3) {
            this.posX = f;
            this.posY = f2 + f3 / 2.0f;
            this.range = f3;
            this.s = 8.0f;
            this.speed = CAVEHUNTER.this.generalSpeed;
            this.dir = PApplet.parseInt((float)CAVEHUNTER.this.random(2.0f));
            if (this.dir < 1 || this.dir == 2) {
                this.dir = -1;
            }
            this.angle = CAVEHUNTER.this.random(360.0f);
        }

        public void positionieren() {
            this.posX -= CAVEHUNTER.this.generalSpeed;
            this.x = this.posX + CAVEHUNTER.cos((float)CAVEHUNTER.radians((float)this.angle)) * (this.range / 2.0f);
            this.y = this.posY + CAVEHUNTER.sin((float)CAVEHUNTER.radians((float)this.angle)) * (this.range / 2.0f);
            this.angle += this.speed * (float)this.dir;
            if (this.angle > 360.0f) {
                this.angle -= 360.0f;
            } else if (this.angle < -360.0f) {
                this.angle += 360.0f;
            }
        }

        public void hitTest() {
            if (CAVEHUNTER.abs((float)(this.x - CAVEHUNTER.this.ship.x)) < this.s / 2.0f + CAVEHUNTER.this.ship.sizeX / 2.0f && CAVEHUNTER.abs((float)(this.y - CAVEHUNTER.this.ship.y)) < this.s / 2.0f + CAVEHUNTER.this.ship.sizeY / 2.0f && CAVEHUNTER.this.collision == 0) {
                CAVEHUNTER.this.collision = 1;
            }
        }

        public void zeichnen() {
            CAVEHUNTER.this.noStroke();
            CAVEHUNTER.this.fill(255.0f, 0.0f, 0.0f);
            CAVEHUNTER.this.rectMode(3);
            CAVEHUNTER.this.rect(this.x, this.y, this.s, this.s);
        }

        public void update() {
            if (CAVEHUNTER.this.collision < 5) {
                this.hitTest();
                this.positionieren();
            }
            this.zeichnen();
        }
    }

    class Point {
        float posX;
        float posY;
        float range;
        float speed;
        float y;
        float angle;
        float s;
        int value;
        int farbe;
        boolean hit = false;

        Point(float f, float f2, float f3) {
            this.posX = f;
            this.posY = f2 + f3 / 2.0f;
            this.range = f3;
            this.s = 10.0f;
            this.speed = CAVEHUNTER.this.generalSpeed;
            this.angle = CAVEHUNTER.this.random(360.0f);
            this.value = PApplet.parseInt((float)CAVEHUNTER.this.random(3.0f)) + 1;
            this.value *= 100;
            switch (this.value) {
                case 100: {
                    this.farbe = CAVEHUNTER.this.color(150, 255, 0);
                    break;
                }
                case 200: {
                    this.farbe = CAVEHUNTER.this.color(255, 220, 0);
                    break;
                }
                case 300: {
                    this.farbe = CAVEHUNTER.this.color(114, 0, 255);
                }
            }
        }

        public void positionieren() {
            this.posX -= CAVEHUNTER.this.generalSpeed;
            this.y = this.posY + CAVEHUNTER.sin((float)CAVEHUNTER.radians((float)this.angle)) * (this.range / 2.0f);
            this.angle += this.speed;
            if (this.angle > 360.0f) {
                this.angle -= 360.0f;
            }
        }

        public void hitTest() {
            if (CAVEHUNTER.abs((float)(this.posX - CAVEHUNTER.this.ship.x)) < this.s / 2.0f + CAVEHUNTER.this.ship.sizeX / 2.0f && CAVEHUNTER.abs((float)(this.y - CAVEHUNTER.this.ship.y)) < this.s / 2.0f + CAVEHUNTER.this.ship.sizeY / 2.0f && !this.hit) {
                CAVEHUNTER.this.score += this.value;
                this.hit = true;
                CAVEHUNTER.this.kasching = CAVEHUNTER.this.minim.loadFile("kasching.mp3", 512);
                CAVEHUNTER.this.kasching.play();
            }
        }

        public void zeichnen() {
            CAVEHUNTER.this.stroke(this.farbe);
            CAVEHUNTER.this.strokeWeight(2.0f);
            CAVEHUNTER.this.noFill();
            CAVEHUNTER.this.ellipse(this.posX, this.y, this.s, this.s);
        }

        public void update() {
            if (!this.hit) {
                if (CAVEHUNTER.this.collision < 5) {
                    this.hitTest();
                    this.positionieren();
                }
                this.zeichnen();
            }
        }
    }

    class Score {
        float x;
        float y;
        PFont font;

        Score() {
            this.x = CAVEHUNTER.this.width - 10;
            this.y = 20.0f;
            this.font = CAVEHUNTER.this.loadFont("AndaleMono-14.vlw");
        }

        public void zeichnen() {
            CAVEHUNTER.this.fill(0.0f, 255.0f, 0.0f);
            CAVEHUNTER.this.textFont(this.font);
            CAVEHUNTER.this.textAlign(39);
            CAVEHUNTER.this.text("score: " + CAVEHUNTER.this.score, this.x, this.y);
        }

        public void update() {
            this.zeichnen();
        }
    }

    class Ship {
        float x;
        float y;
        float targetX;
        float targetY;
        float sizeX = 10.0f;
        float sizeY = 5.0f;
        float speed = 2.0f;
        int[] tiltAusgleich;
        int[] tilt = new int[2];
        int[] values;

        Ship(int[] nArray) {
            this.x = this.targetX = (float)(CAVEHUNTER.this.width / 2);
            this.y = this.targetY = (float)(CAVEHUNTER.this.height / 2);
            this.tiltAusgleich = nArray;
        }

        public void positionieren() {
            this.values = Unimotion.getSMSArray();
            this.tilt[0] = this.values[0] - this.tiltAusgleich[0];
            this.tilt[1] = this.values[1] - this.tiltAusgleich[1];
            this.targetX = CAVEHUNTER.map((float)this.tilt[0], (float)-20.0f, (float)20.0f, (float)0.0f, (float)CAVEHUNTER.this.width);
            this.targetY = CAVEHUNTER.map((float)this.tilt[1], (float)20.0f, (float)-20.0f, (float)0.0f, (float)CAVEHUNTER.this.height);
            this.x += (float)(this.tilt[0] / 5);
            this.y -= (float)(this.tilt[1] / 5);
            if ((this.x - this.sizeX / 2.0f < 0.0f || this.x + this.sizeX / 2.0f > (float)CAVEHUNTER.this.width) && CAVEHUNTER.this.collision == 0) {
                CAVEHUNTER.this.collision = 1;
            }
        }

        public void zeichnen() {
            if (CAVEHUNTER.this.collision == 0) {
                CAVEHUNTER.this.noStroke();
                CAVEHUNTER.this.fill(72.0f, 180.0f, 255.0f);
                CAVEHUNTER.this.rectMode(3);
                CAVEHUNTER.this.rect(this.x, this.y, this.sizeX, this.sizeY);
            } else if (CAVEHUNTER.this.collision > 0 && CAVEHUNTER.this.collision < 5) {
                CAVEHUNTER.this.explode(this.x, this.y);
                ++CAVEHUNTER.this.collision;
            }
        }

        public void update() {
            if (CAVEHUNTER.this.collision < 5) {
                this.positionieren();
                this.zeichnen();
            }
        }
    }

    class Start {
        float x = 0.0f;
        float y;
        float sizeY = 60.0f;

        Start() {
            this.y = (float)(CAVEHUNTER.this.height / 2) - this.sizeY / 2.0f;
        }

        public void positionieren() {
            this.x -= CAVEHUNTER.this.generalSpeed;
        }

        public void hitTest() {
            if ((CAVEHUNTER.this.ship.y - CAVEHUNTER.this.ship.sizeY / 2.0f < this.y || CAVEHUNTER.this.ship.y + CAVEHUNTER.this.ship.sizeY / 2.0f > this.y + this.sizeY) && CAVEHUNTER.this.collision == 0 && CAVEHUNTER.this.ship.x - CAVEHUNTER.this.ship.sizeX < this.x + (float)CAVEHUNTER.this.width) {
                CAVEHUNTER.this.collision = 1;
            }
        }

        public void zeichnen() {
            CAVEHUNTER.this.noStroke();
            CAVEHUNTER.this.fill(255);
            CAVEHUNTER.this.rectMode(0);
            CAVEHUNTER.this.rect(this.x, this.y, CAVEHUNTER.this.width, this.sizeY);
        }

        public void update() {
            if (this.x > (float)(-CAVEHUNTER.this.width) && CAVEHUNTER.this.collision < 5) {
                this.hitTest();
                this.positionieren();
            }
            this.zeichnen();
        }
    }

    class StartScreen {
        PImage pic;
        PFont font;
        boolean show = true;

        StartScreen() {
            this.font = CAVEHUNTER.this.loadFont("AndaleMono-30.vlw");
            this.pic = CAVEHUNTER.this.loadImage("startScreen.png");
        }

        public void zeichnen() {
            CAVEHUNTER.this.image(this.pic, 0.0f, 0.0f);
            if (CAVEHUNTER.this.frameCount % 30 == 0) {
                this.show = !this.show;
            }
            if (this.show) {
                CAVEHUNTER.this.fill(255);
                CAVEHUNTER.this.textFont(this.font);
                CAVEHUNTER.this.textAlign(3);
                CAVEHUNTER.this.text("* Press 'RIGHT' to play! *", CAVEHUNTER.this.width / 2, CAVEHUNTER.this.height - 50);
            }
        }

        public void update() {
            this.zeichnen();
        }
    }
}

