/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PGraphicsJava2D;
import processing.core.PMatrix2D;
import processing.core.PShape;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PShapeSVG
extends PShape {
    XMLElement element;
    float opacity;
    float strokeOpacity;
    float fillOpacity;
    Gradient strokeGradient;
    Paint strokeGradientPaint;
    String strokeName;
    Gradient fillGradient;
    Paint fillGradientPaint;
    String fillName;

    public PShapeSVG(PApplet parent, String filename) {
        this(new XMLElement(parent, filename));
    }

    public PShapeSVG(XMLElement svg) {
        this(null, svg);
        if (!svg.getName().equals("svg")) {
            throw new RuntimeException("root is not <svg>, it's <" + svg.getName() + ">");
        }
        String viewBoxStr = svg.getString("viewBox");
        if (viewBoxStr != null) {
            int[] viewBox = PApplet.parseInt(PApplet.splitTokens(viewBoxStr));
            this.width = viewBox[2];
            this.height = viewBox[3];
        }
        String unitWidth = svg.getString("width");
        String unitHeight = svg.getString("height");
        if (unitWidth != null) {
            this.width = PShapeSVG.parseUnitSize(unitWidth);
            this.height = PShapeSVG.parseUnitSize(unitHeight);
        } else if (this.width == 0.0f || this.height == 0.0f) {
            PGraphics.showWarning("The width and/or height is not readable in the <svg> tag of this file.");
            this.width = 1.0f;
            this.height = 1.0f;
        }
        this.parseChildren(svg);
    }

    public PShapeSVG(PShapeSVG parent, XMLElement properties) {
        String displayStr;
        this.parent = parent;
        if (parent == null) {
            this.stroke = false;
            this.strokeColor = -16777216;
            this.strokeWeight = 1.0f;
            this.strokeCap = 1;
            this.strokeJoin = 8;
            this.strokeGradient = null;
            this.strokeGradientPaint = null;
            this.strokeName = null;
            this.fill = true;
            this.fillColor = -16777216;
            this.fillGradient = null;
            this.fillGradientPaint = null;
            this.fillName = null;
            this.strokeOpacity = 1.0f;
            this.fillOpacity = 1.0f;
            this.opacity = 1.0f;
        } else {
            this.stroke = parent.stroke;
            this.strokeColor = parent.strokeColor;
            this.strokeWeight = parent.strokeWeight;
            this.strokeCap = parent.strokeCap;
            this.strokeJoin = parent.strokeJoin;
            this.strokeGradient = parent.strokeGradient;
            this.strokeGradientPaint = parent.strokeGradientPaint;
            this.strokeName = parent.strokeName;
            this.fill = parent.fill;
            this.fillColor = parent.fillColor;
            this.fillGradient = parent.fillGradient;
            this.fillGradientPaint = parent.fillGradientPaint;
            this.fillName = parent.fillName;
            this.opacity = parent.opacity;
        }
        this.element = properties;
        this.name = properties.getString("id");
        if (this.name != null) {
            String[] m;
            while ((m = PApplet.match(this.name, "_x([A-Za-z0-9]{2})_")) != null) {
                char repair = (char)PApplet.unhex(m[1]);
                this.name = this.name.replace(m[0], "" + repair);
            }
        }
        this.visible = !(displayStr = properties.getString("display", "inline")).equals("none");
        String transformStr = properties.getString("transform");
        if (transformStr != null) {
            this.matrix = PShapeSVG.parseMatrix(transformStr);
        }
        this.parseColors(properties);
        this.parseChildren(properties);
    }

    protected void parseChildren(XMLElement graphics) {
        XMLElement[] elements = graphics.getChildren();
        this.children = new PShape[elements.length];
        this.childCount = 0;
        XMLElement[] xMLElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            XMLElement elem = xMLElementArray[n2];
            PShape kid = this.parseChild(elem);
            if (kid != null) {
                this.addChild(kid);
            }
            ++n2;
        }
    }

    protected PShape parseChild(XMLElement elem) {
        String name = elem.getName();
        PShapeSVG shape = null;
        if (name.equals("g")) {
            shape = new PShapeSVG(this, elem);
        } else if (name.equals("defs")) {
            shape = new PShapeSVG(this, elem);
        } else if (name.equals("line")) {
            shape = new PShapeSVG(this, elem);
            shape.parseLine();
        } else if (name.equals("circle")) {
            shape = new PShapeSVG(this, elem);
            shape.parseEllipse(true);
        } else if (name.equals("ellipse")) {
            shape = new PShapeSVG(this, elem);
            shape.parseEllipse(false);
        } else if (name.equals("rect")) {
            shape = new PShapeSVG(this, elem);
            shape.parseRect();
        } else if (name.equals("polygon")) {
            shape = new PShapeSVG(this, elem);
            shape.parsePoly(true);
        } else if (name.equals("polyline")) {
            shape = new PShapeSVG(this, elem);
            shape.parsePoly(false);
        } else if (name.equals("path")) {
            shape = new PShapeSVG(this, elem);
            shape.parsePath();
        } else {
            if (name.equals("radialGradient")) {
                return new RadialGradient(this, elem);
            }
            if (name.equals("linearGradient")) {
                return new LinearGradient(this, elem);
            }
            if (name.equals("text") || name.equals("font")) {
                PGraphics.showWarning("Text and fonts in SVG files are not currently supported, convert text to outlines instead.");
            } else if (name.equals("filter")) {
                PGraphics.showWarning("Filters are not supported.");
            } else if (name.equals("mask")) {
                PGraphics.showWarning("Masks are not supported.");
            } else if (name.equals("pattern")) {
                PGraphics.showWarning("Patterns are not supported.");
            } else if (!name.equals("stop") && !name.equals("sodipodi:namedview")) {
                PGraphics.showWarning("Ignoring  <" + name + "> tag.");
            }
        }
        return shape;
    }

    protected void parseLine() {
        this.primitive = 4;
        this.family = 1;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x1"), PShapeSVG.getFloatWithUnit(this.element, "y1"), PShapeSVG.getFloatWithUnit(this.element, "x2"), PShapeSVG.getFloatWithUnit(this.element, "y2")};
    }

    protected void parseEllipse(boolean circle) {
        float rx;
        float ry;
        this.primitive = 31;
        this.family = 1;
        this.params = new float[4];
        this.params[0] = PShapeSVG.getFloatWithUnit(this.element, "cx");
        this.params[1] = PShapeSVG.getFloatWithUnit(this.element, "cy");
        if (circle) {
            rx = ry = PShapeSVG.getFloatWithUnit(this.element, "r");
        } else {
            rx = PShapeSVG.getFloatWithUnit(this.element, "rx");
            ry = PShapeSVG.getFloatWithUnit(this.element, "ry");
        }
        this.params[0] = this.params[0] - rx;
        this.params[1] = this.params[1] - ry;
        this.params[2] = rx * 2.0f;
        this.params[3] = ry * 2.0f;
    }

    protected void parseRect() {
        this.primitive = 30;
        this.family = 1;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x"), PShapeSVG.getFloatWithUnit(this.element, "y"), PShapeSVG.getFloatWithUnit(this.element, "width"), PShapeSVG.getFloatWithUnit(this.element, "height")};
    }

    protected void parsePoly(boolean close) {
        this.family = 2;
        this.close = close;
        String pointsAttr = this.element.getString("points");
        if (pointsAttr != null) {
            String[] pointsBuffer = PApplet.splitTokens(pointsAttr);
            this.vertexCount = pointsBuffer.length;
            this.vertices = new float[this.vertexCount][2];
            int i = 0;
            while (i < this.vertexCount) {
                String[] pb = PApplet.split(pointsBuffer[i], ',');
                this.vertices[i][0] = Float.valueOf(pb[0]).floatValue();
                this.vertices[i][1] = Float.valueOf(pb[1]).floatValue();
                ++i;
            }
        }
    }

    protected void parsePath() {
        this.family = 2;
        this.primitive = 0;
        String pathData = this.element.getString("d");
        if (pathData == null) {
            return;
        }
        char[] pathDataChars = pathData.toCharArray();
        StringBuffer pathBuffer = new StringBuffer();
        boolean lastSeparate = false;
        int i = 0;
        while (i < pathDataChars.length) {
            char c = pathDataChars[i];
            boolean separate = false;
            if (c == 'M' || c == 'm' || c == 'L' || c == 'l' || c == 'H' || c == 'h' || c == 'V' || c == 'v' || c == 'C' || c == 'c' || c == 'S' || c == 's' || c == 'Q' || c == 'q' || c == 'T' || c == 't' || c == 'Z' || c == 'z' || c == ',') {
                separate = true;
                if (i != 0) {
                    pathBuffer.append("|");
                }
            }
            if (c == 'Z' || c == 'z') {
                separate = false;
            }
            if (!(c != '-' || lastSeparate || i != 0 && pathDataChars[i - 1] == 'e')) {
                pathBuffer.append("|");
            }
            if (c != ',') {
                pathBuffer.append(c);
            }
            if (separate && c != ',' && c != '-') {
                pathBuffer.append("|");
            }
            lastSeparate = separate;
            ++i;
        }
        String[] pathDataKeys = PApplet.splitTokens(pathBuffer.toString(), "| \t\n\r\f\u00a0");
        this.vertices = new float[pathDataKeys.length][2];
        this.vertexCodes = new int[pathDataKeys.length];
        float cx = 0.0f;
        float cy = 0.0f;
        int i2 = 0;
        int implicitCommand = 0;
        while (i2 < pathDataKeys.length) {
            int c = pathDataKeys[i2].charAt(0);
            if ((c >= 48 && c <= 57 || c == 45) && implicitCommand != 0) {
                c = implicitCommand;
                --i2;
            } else {
                implicitCommand = c;
            }
            switch (c) {
                case 77: {
                    cx = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    cy = PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    this.parsePathMoveto(cx, cy);
                    implicitCommand = 76;
                    i2 += 3;
                    break;
                }
                case 109: {
                    this.parsePathMoveto(cx += PApplet.parseFloat(pathDataKeys[i2 + 1]), cy += PApplet.parseFloat(pathDataKeys[i2 + 2]));
                    implicitCommand = 108;
                    i2 += 3;
                    break;
                }
                case 76: {
                    cx = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    cy = PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    this.parsePathLineto(cx, cy);
                    i2 += 3;
                    break;
                }
                case 108: {
                    this.parsePathLineto(cx += PApplet.parseFloat(pathDataKeys[i2 + 1]), cy += PApplet.parseFloat(pathDataKeys[i2 + 2]));
                    i2 += 3;
                    break;
                }
                case 72: {
                    cx = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    this.parsePathLineto(cx, cy);
                    i2 += 2;
                    break;
                }
                case 104: {
                    this.parsePathLineto(cx += PApplet.parseFloat(pathDataKeys[i2 + 1]), cy);
                    i2 += 2;
                    break;
                }
                case 86: {
                    cy = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    this.parsePathLineto(cx, cy);
                    i2 += 2;
                    break;
                }
                case 118: {
                    this.parsePathLineto(cx, cy += PApplet.parseFloat(pathDataKeys[i2 + 1]));
                    i2 += 2;
                    break;
                }
                case 67: {
                    float ctrlX1 = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float ctrlY1 = PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    float ctrlX2 = PApplet.parseFloat(pathDataKeys[i2 + 3]);
                    float ctrlY2 = PApplet.parseFloat(pathDataKeys[i2 + 4]);
                    float endX = PApplet.parseFloat(pathDataKeys[i2 + 5]);
                    float endY = PApplet.parseFloat(pathDataKeys[i2 + 6]);
                    this.parsePathCurveto(ctrlX1, ctrlY1, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 7;
                    break;
                }
                case 99: {
                    float ctrlX1 = cx + PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float ctrlY1 = cy + PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    float ctrlX2 = cx + PApplet.parseFloat(pathDataKeys[i2 + 3]);
                    float ctrlY2 = cy + PApplet.parseFloat(pathDataKeys[i2 + 4]);
                    float endX = cx + PApplet.parseFloat(pathDataKeys[i2 + 5]);
                    float endY = cy + PApplet.parseFloat(pathDataKeys[i2 + 6]);
                    this.parsePathCurveto(ctrlX1, ctrlY1, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 7;
                    break;
                }
                case 83: {
                    float ppx = this.vertices[this.vertexCount - 2][0];
                    float ppy = this.vertices[this.vertexCount - 2][1];
                    float px = this.vertices[this.vertexCount - 1][0];
                    float py = this.vertices[this.vertexCount - 1][1];
                    float ctrlX1 = px + (px - ppx);
                    float ctrlY1 = py + (py - ppy);
                    float ctrlX2 = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float ctrlY2 = PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    float endX = PApplet.parseFloat(pathDataKeys[i2 + 3]);
                    float endY = PApplet.parseFloat(pathDataKeys[i2 + 4]);
                    this.parsePathCurveto(ctrlX1, ctrlY1, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 5;
                    break;
                }
                case 115: {
                    float ppx = this.vertices[this.vertexCount - 2][0];
                    float ppy = this.vertices[this.vertexCount - 2][1];
                    float px = this.vertices[this.vertexCount - 1][0];
                    float py = this.vertices[this.vertexCount - 1][1];
                    float ctrlX1 = px + (px - ppx);
                    float ctrlY1 = py + (py - ppy);
                    float ctrlX2 = cx + PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float ctrlY2 = cy + PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    float endX = cx + PApplet.parseFloat(pathDataKeys[i2 + 3]);
                    float endY = cy + PApplet.parseFloat(pathDataKeys[i2 + 4]);
                    this.parsePathCurveto(ctrlX1, ctrlY1, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 5;
                    break;
                }
                case 81: {
                    float ctrlX = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float ctrlY = PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    float endX = PApplet.parseFloat(pathDataKeys[i2 + 3]);
                    float endY = PApplet.parseFloat(pathDataKeys[i2 + 4]);
                    this.parsePathQuadto(cx, cy, ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 5;
                    break;
                }
                case 113: {
                    float ctrlX = cx + PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float ctrlY = cy + PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    float endX = cx + PApplet.parseFloat(pathDataKeys[i2 + 3]);
                    float endY = cy + PApplet.parseFloat(pathDataKeys[i2 + 4]);
                    this.parsePathQuadto(cx, cy, ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 5;
                    break;
                }
                case 84: {
                    float ppx = this.vertices[this.vertexCount - 2][0];
                    float ppy = this.vertices[this.vertexCount - 2][1];
                    float px = this.vertices[this.vertexCount - 1][0];
                    float py = this.vertices[this.vertexCount - 1][1];
                    float ctrlX = px + (px - ppx);
                    float ctrlY = py + (py - ppy);
                    float endX = PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float endY = PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    this.parsePathQuadto(cx, cy, ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 3;
                    break;
                }
                case 116: {
                    float ppx = this.vertices[this.vertexCount - 2][0];
                    float ppy = this.vertices[this.vertexCount - 2][1];
                    float px = this.vertices[this.vertexCount - 1][0];
                    float py = this.vertices[this.vertexCount - 1][1];
                    float ctrlX = px + (px - ppx);
                    float ctrlY = py + (py - ppy);
                    float endX = cx + PApplet.parseFloat(pathDataKeys[i2 + 1]);
                    float endY = cy + PApplet.parseFloat(pathDataKeys[i2 + 2]);
                    this.parsePathQuadto(cx, cy, ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i2 += 3;
                    break;
                }
                case 90: 
                case 122: {
                    this.close = true;
                    ++i2;
                    break;
                }
                default: {
                    String parsed = PApplet.join(PApplet.subset(pathDataKeys, 0, i2), ",");
                    String unparsed = PApplet.join(PApplet.subset(pathDataKeys, i2), ",");
                    System.err.println("parsed: " + parsed);
                    System.err.println("unparsed: " + unparsed);
                    if (pathDataKeys[i2].equals("a") || pathDataKeys[i2].equals("A")) {
                        String msg = "Sorry, elliptical arc support for SVG files is not yet implemented (See bug #996 for details)";
                        throw new RuntimeException(msg);
                    }
                    throw new RuntimeException("shape command not handled: " + pathDataKeys[i2]);
                }
            }
        }
    }

    private void parsePathVertex(float x, float y) {
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][2];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
        this.vertices[this.vertexCount][0] = x;
        this.vertices[this.vertexCount][1] = y;
        ++this.vertexCount;
    }

    private void parsePathCode(int what) {
        if (this.vertexCodeCount == this.vertexCodes.length) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = what;
    }

    private void parsePathMoveto(float px, float py) {
        if (this.vertexCount > 0) {
            this.parsePathCode(3);
        }
        this.parsePathCode(0);
        this.parsePathVertex(px, py);
    }

    private void parsePathLineto(float px, float py) {
        this.parsePathCode(0);
        this.parsePathVertex(px, py);
    }

    private void parsePathCurveto(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.parsePathCode(1);
        this.parsePathVertex(x1, y1);
        this.parsePathVertex(x2, y2);
        this.parsePathVertex(x3, y3);
    }

    private void parsePathQuadto(float x1, float y1, float cx, float cy, float x2, float y2) {
        this.parsePathCode(1);
        this.parsePathVertex(x1 + (cx - x1) * 2.0f / 3.0f, y1 + (cy - y1) * 2.0f / 3.0f);
        this.parsePathVertex(x2 + (cx - x2) * 2.0f / 3.0f, y2 + (cy - y2) * 2.0f / 3.0f);
        this.parsePathVertex(x2, y2);
    }

    protected static PMatrix2D parseMatrix(String matrixStr) {
        String[] pieces = PApplet.match(matrixStr, "\\s*(\\w+)\\((.*)\\)");
        if (pieces == null) {
            System.err.println("Could not parse transform " + matrixStr);
            return null;
        }
        float[] m = PApplet.parseFloat(PApplet.splitTokens(pieces[2], ", "));
        if (pieces[1].equals("matrix")) {
            return new PMatrix2D(m[0], m[2], m[4], m[1], m[3], m[5]);
        }
        if (pieces[1].equals("translate")) {
            float tx = m[0];
            float ty = m.length == 2 ? m[1] : m[0];
            return new PMatrix2D(1.0f, 0.0f, tx, 0.0f, 1.0f, ty);
        }
        if (pieces[1].equals("scale")) {
            float sx = m[0];
            float sy = m.length == 2 ? m[1] : m[0];
            return new PMatrix2D(sx, 0.0f, 0.0f, 0.0f, sy, 0.0f);
        }
        if (pieces[1].equals("rotate")) {
            float angle = m[0];
            if (m.length == 1) {
                float c = PApplet.cos(angle);
                float s = PApplet.sin(angle);
                return new PMatrix2D(c, -s, 0.0f, s, c, 0.0f);
            }
            if (m.length == 3) {
                PMatrix2D mat = new PMatrix2D(0.0f, 1.0f, m[1], 1.0f, 0.0f, m[2]);
                mat.rotate(m[0]);
                mat.translate(-m[1], -m[2]);
                return mat;
            }
        } else {
            if (pieces[1].equals("skewX")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, PApplet.tan(m[0]), 0.0f, 0.0f);
            }
            if (pieces[1].equals("skewY")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, 0.0f, PApplet.tan(m[0]), 0.0f);
            }
        }
        return null;
    }

    protected void parseColors(XMLElement properties) {
        if (properties.hasAttribute("opacity")) {
            String opacityText = properties.getString("opacity");
            this.setOpacity(opacityText);
        }
        if (properties.hasAttribute("stroke")) {
            String strokeText = properties.getString("stroke");
            this.setColor(strokeText, false);
        }
        if (properties.hasAttribute("stroke-opacity")) {
            String strokeOpacityText = properties.getString("stroke-opacity");
            this.setStrokeOpacity(strokeOpacityText);
        }
        if (properties.hasAttribute("stroke-width")) {
            String lineweight = properties.getString("stroke-width");
            this.setStrokeWeight(lineweight);
        }
        if (properties.hasAttribute("stroke-linejoin")) {
            String linejoin = properties.getString("stroke-linejoin");
            this.setStrokeJoin(linejoin);
        }
        if (properties.hasAttribute("stroke-linecap")) {
            String linecap = properties.getString("stroke-linecap");
            this.setStrokeCap(linecap);
        }
        if (properties.hasAttribute("fill")) {
            String fillText = properties.getString("fill");
            this.setColor(fillText, true);
        }
        if (properties.hasAttribute("fill-opacity")) {
            String fillOpacityText = properties.getString("fill-opacity");
            this.setFillOpacity(fillOpacityText);
        }
        if (properties.hasAttribute("style")) {
            String styleText = properties.getString("style");
            String[] styleTokens = PApplet.splitTokens(styleText, ";");
            int i = 0;
            while (i < styleTokens.length) {
                String[] tokens = PApplet.splitTokens(styleTokens[i], ":");
                tokens[0] = PApplet.trim(tokens[0]);
                if (tokens[0].equals("fill")) {
                    this.setColor(tokens[1], true);
                } else if (tokens[0].equals("fill-opacity")) {
                    this.setFillOpacity(tokens[1]);
                } else if (tokens[0].equals("stroke")) {
                    this.setColor(tokens[1], false);
                } else if (tokens[0].equals("stroke-width")) {
                    this.setStrokeWeight(tokens[1]);
                } else if (tokens[0].equals("stroke-linecap")) {
                    this.setStrokeCap(tokens[1]);
                } else if (tokens[0].equals("stroke-linejoin")) {
                    this.setStrokeJoin(tokens[1]);
                } else if (tokens[0].equals("stroke-opacity")) {
                    this.setStrokeOpacity(tokens[1]);
                } else if (tokens[0].equals("opacity")) {
                    this.setOpacity(tokens[1]);
                }
                ++i;
            }
        }
    }

    void setOpacity(String opacityText) {
        this.opacity = PApplet.parseFloat(opacityText);
        this.strokeColor = (int)(this.opacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
        this.fillColor = (int)(this.opacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setStrokeWeight(String lineweight) {
        this.strokeWeight = PShapeSVG.parseUnitSize(lineweight);
    }

    void setStrokeOpacity(String opacityText) {
        this.strokeOpacity = PApplet.parseFloat(opacityText);
        this.strokeColor = (int)(this.strokeOpacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
    }

    void setStrokeJoin(String linejoin) {
        if (!linejoin.equals("inherit")) {
            if (linejoin.equals("miter")) {
                this.strokeJoin = 8;
            } else if (linejoin.equals("round")) {
                this.strokeJoin = 2;
            } else if (linejoin.equals("bevel")) {
                this.strokeJoin = 32;
            }
        }
    }

    void setStrokeCap(String linecap) {
        if (!linecap.equals("inherit")) {
            if (linecap.equals("butt")) {
                this.strokeCap = 1;
            } else if (linecap.equals("round")) {
                this.strokeCap = 2;
            } else if (linecap.equals("square")) {
                this.strokeCap = 4;
            }
        }
    }

    void setFillOpacity(String opacityText) {
        this.fillOpacity = PApplet.parseFloat(opacityText);
        this.fillColor = (int)(this.fillOpacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setColor(String colorText, boolean isFill) {
        int opacityMask = this.fillColor & 0xFF000000;
        boolean visible = true;
        int color = 0;
        String name = "";
        Gradient gradient = null;
        Paint paint = null;
        if (colorText.equals("none")) {
            visible = false;
        } else if (colorText.equals("black")) {
            color = opacityMask;
        } else if (colorText.equals("white")) {
            color = opacityMask | 0xFFFFFF;
        } else if (colorText.startsWith("#")) {
            if (colorText.length() == 4) {
                colorText = colorText.replaceAll("^#(.)(.)(.)$", "#$1$1$2$2$3$3");
            }
            color = opacityMask | Integer.parseInt(colorText.substring(1), 16) & 0xFFFFFF;
        } else if (colorText.startsWith("rgb")) {
            color = opacityMask | PShapeSVG.parseRGB(colorText);
        } else if (colorText.startsWith("url(#")) {
            name = colorText.substring(5, colorText.length() - 1);
            PShape object = this.findChild(name);
            if (object instanceof Gradient) {
                gradient = (Gradient)object;
                paint = this.calcGradientPaint(gradient);
            } else {
                System.err.println("url " + name + " refers to unexpected data: " + object);
            }
        }
        if (isFill) {
            this.fill = visible;
            this.fillColor = color;
            this.fillName = name;
            this.fillGradient = gradient;
            this.fillGradientPaint = paint;
        } else {
            this.stroke = visible;
            this.strokeColor = color;
            this.strokeName = name;
            this.strokeGradient = gradient;
            this.strokeGradientPaint = paint;
        }
    }

    protected static int parseRGB(String what) {
        int leftParen = what.indexOf(40) + 1;
        int rightParen = what.indexOf(41);
        String sub = what.substring(leftParen, rightParen);
        int[] values = PApplet.parseInt(PApplet.splitTokens(sub, ", "));
        return values[0] << 16 | values[1] << 8 | values[2];
    }

    protected static HashMap<String, String> parseStyleAttributes(String style) {
        HashMap<String, String> table = new HashMap<String, String>();
        String[] pieces = style.split(";");
        int i = 0;
        while (i < pieces.length) {
            String[] parts = pieces[i].split(":");
            table.put(parts[0], parts[1]);
            ++i;
        }
        return table;
    }

    protected static float getFloatWithUnit(XMLElement element, String attribute) {
        String val = element.getString(attribute);
        return val == null ? 0.0f : PShapeSVG.parseUnitSize(val);
    }

    protected static float parseUnitSize(String text) {
        int len = text.length() - 2;
        if (text.endsWith("pt")) {
            return PApplet.parseFloat(text.substring(0, len)) * 1.25f;
        }
        if (text.endsWith("pc")) {
            return PApplet.parseFloat(text.substring(0, len)) * 15.0f;
        }
        if (text.endsWith("mm")) {
            return PApplet.parseFloat(text.substring(0, len)) * 3.543307f;
        }
        if (text.endsWith("cm")) {
            return PApplet.parseFloat(text.substring(0, len)) * 35.43307f;
        }
        if (text.endsWith("in")) {
            return PApplet.parseFloat(text.substring(0, len)) * 90.0f;
        }
        if (text.endsWith("px")) {
            return PApplet.parseFloat(text.substring(0, len));
        }
        return PApplet.parseFloat(text);
    }

    protected Paint calcGradientPaint(Gradient gradient) {
        if (gradient instanceof LinearGradient) {
            LinearGradient grad = (LinearGradient)gradient;
            return new LinearGradientPaint(grad.x1, grad.y1, grad.x2, grad.y2, grad.offset, grad.color, grad.count, this.opacity);
        }
        if (gradient instanceof RadialGradient) {
            RadialGradient grad = (RadialGradient)gradient;
            return new RadialGradientPaint(grad.cx, grad.cy, grad.r, grad.offset, grad.color, grad.count, this.opacity);
        }
        return null;
    }

    @Override
    protected void styles(PGraphics g) {
        super.styles(g);
        if (g instanceof PGraphicsJava2D) {
            PGraphicsJava2D p2d = (PGraphicsJava2D)g;
            if (this.strokeGradient != null) {
                p2d.strokeGradient = true;
                p2d.strokeGradientObject = this.strokeGradientPaint;
            }
            if (this.fillGradient != null) {
                p2d.fillGradient = true;
                p2d.fillGradientObject = this.fillGradientPaint;
            }
        }
    }

    @Override
    public PShape getChild(String name) {
        PShape found = super.getChild(name);
        if (found == null) {
            found = super.getChild(name.replace(' ', '_'));
        }
        if (found != null) {
            found.width = this.width;
            found.height = this.height;
        }
        return found;
    }

    public void print() {
        PApplet.println(this.element.toString());
    }

    static class Gradient
    extends PShapeSVG {
        AffineTransform transform;
        float[] offset;
        int[] color;
        int count;

        public Gradient(PShapeSVG parent, XMLElement properties) {
            super(parent, properties);
            XMLElement[] elements = properties.getChildren();
            this.offset = new float[elements.length];
            this.color = new int[elements.length];
            int i = 0;
            while (i < elements.length) {
                XMLElement elem = elements[i];
                String name = elem.getName();
                if (name.equals("stop")) {
                    String opacityStr;
                    String offsetAttr = elem.getString("offset");
                    float div = 1.0f;
                    if (offsetAttr.endsWith("%")) {
                        div = 100.0f;
                        offsetAttr = offsetAttr.substring(0, offsetAttr.length() - 1);
                    }
                    this.offset[this.count] = PApplet.parseFloat(offsetAttr) / div;
                    String style = elem.getString("style");
                    HashMap<String, String> styles = Gradient.parseStyleAttributes(style);
                    String colorStr = styles.get("stop-color");
                    if (colorStr == null) {
                        colorStr = "#000000";
                    }
                    if ((opacityStr = styles.get("stop-opacity")) == null) {
                        opacityStr = "1";
                    }
                    int tupacity = (int)(PApplet.parseFloat(opacityStr) * 255.0f);
                    this.color[this.count] = tupacity << 24 | Integer.parseInt(colorStr.substring(1), 16);
                    ++this.count;
                }
                ++i;
            }
            this.offset = PApplet.subset(this.offset, 0, this.count);
            this.color = PApplet.subset(this.color, 0, this.count);
        }
    }

    class LinearGradient
    extends Gradient {
        float x1;
        float y1;
        float x2;
        float y2;

        public LinearGradient(PShapeSVG parent, XMLElement properties) {
            super(parent, properties);
            this.x1 = LinearGradient.getFloatWithUnit(properties, "x1");
            this.y1 = LinearGradient.getFloatWithUnit(properties, "y1");
            this.x2 = LinearGradient.getFloatWithUnit(properties, "x2");
            this.y2 = LinearGradient.getFloatWithUnit(properties, "y2");
            String transformStr = properties.getString("gradientTransform");
            if (transformStr != null) {
                float[] t = LinearGradient.parseMatrix(transformStr).get(null);
                this.transform = new AffineTransform(t[0], t[3], t[1], t[4], t[2], t[5]);
                Point2D t1 = this.transform.transform(new Point2D.Float(this.x1, this.y1), null);
                Point2D t2 = this.transform.transform(new Point2D.Float(this.x2, this.y2), null);
                this.x1 = (float)t1.getX();
                this.y1 = (float)t1.getY();
                this.x2 = (float)t2.getX();
                this.y2 = (float)t2.getY();
            }
        }
    }

    class LinearGradientPaint
    implements Paint {
        float x1;
        float y1;
        float x2;
        float y2;
        float[] offset;
        int[] color;
        int count;
        float opacity;

        public LinearGradientPaint(float x1, float y1, float x2, float y2, float[] offset, int[] color, int count, float opacity) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.offset = offset;
            this.color = color;
            this.count = count;
            this.opacity = opacity;
        }

        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            Point2D t1 = xform.transform(new Point2D.Float(this.x1, this.y1), null);
            Point2D t2 = xform.transform(new Point2D.Float(this.x2, this.y2), null);
            return new LinearGradientContext((float)t1.getX(), (float)t1.getY(), (float)t2.getX(), (float)t2.getY());
        }

        public int getTransparency() {
            return 3;
        }

        public class LinearGradientContext
        implements PaintContext {
            int ACCURACY = 2;
            float tx1;
            float ty1;
            float tx2;
            float ty2;

            public LinearGradientContext(float tx1, float ty1, float tx2, float ty2) {
                this.tx1 = tx1;
                this.ty1 = ty1;
                this.tx2 = tx2;
                this.ty2 = ty2;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            public Raster getRaster(int x, int y, int w, int h) {
                int span;
                WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
                int[] data = new int[w * h * 4];
                float nx = this.tx2 - this.tx1;
                float ny = this.ty2 - this.ty1;
                float len = (float)Math.sqrt(nx * nx + ny * ny);
                if (len != 0.0f) {
                    nx /= len;
                    ny /= len;
                }
                if ((span = (int)PApplet.dist(this.tx1, this.ty1, this.tx2, this.ty2) * this.ACCURACY) <= 0) {
                    int index = 0;
                    int j = 0;
                    while (j < h) {
                        int i = 0;
                        while (i < w) {
                            data[index++] = 0;
                            data[index++] = 0;
                            data[index++] = 0;
                            data[index++] = 255;
                            ++i;
                        }
                        ++j;
                    }
                } else {
                    int[][] interp = new int[span][4];
                    int prev = 0;
                    int i = 1;
                    while (i < LinearGradientPaint.this.count) {
                        int c0 = LinearGradientPaint.this.color[i - 1];
                        int c1 = LinearGradientPaint.this.color[i];
                        int last = (int)(LinearGradientPaint.this.offset[i] * (float)(span - 1));
                        int j = prev;
                        while (j <= last) {
                            float btwn = PApplet.norm(j, prev, last);
                            interp[j][0] = (int)PApplet.lerp(c0 >> 16 & 0xFF, c1 >> 16 & 0xFF, btwn);
                            interp[j][1] = (int)PApplet.lerp(c0 >> 8 & 0xFF, c1 >> 8 & 0xFF, btwn);
                            interp[j][2] = (int)PApplet.lerp(c0 & 0xFF, c1 & 0xFF, btwn);
                            interp[j][3] = (int)(PApplet.lerp(c0 >> 24 & 0xFF, c1 >> 24 & 0xFF, btwn) * LinearGradientPaint.this.opacity);
                            ++j;
                        }
                        prev = last;
                        ++i;
                    }
                    int index = 0;
                    int j = 0;
                    while (j < h) {
                        int i2 = 0;
                        while (i2 < w) {
                            float px = (float)(x + i2) - this.tx1;
                            float py = (float)(y + j) - this.ty1;
                            int which = (int)((px * nx + py * ny) * (float)this.ACCURACY);
                            if (which < 0) {
                                which = 0;
                            }
                            if (which > interp.length - 1) {
                                which = interp.length - 1;
                            }
                            data[index++] = interp[which][0];
                            data[index++] = interp[which][1];
                            data[index++] = interp[which][2];
                            data[index++] = interp[which][3];
                            ++i2;
                        }
                        ++j;
                    }
                }
                raster.setPixels(0, 0, w, h, data);
                return raster;
            }
        }
    }

    class RadialGradient
    extends Gradient {
        float cx;
        float cy;
        float r;

        public RadialGradient(PShapeSVG parent, XMLElement properties) {
            super(parent, properties);
            this.cx = RadialGradient.getFloatWithUnit(properties, "cx");
            this.cy = RadialGradient.getFloatWithUnit(properties, "cy");
            this.r = RadialGradient.getFloatWithUnit(properties, "r");
            String transformStr = properties.getString("gradientTransform");
            if (transformStr != null) {
                float[] t = RadialGradient.parseMatrix(transformStr).get(null);
                this.transform = new AffineTransform(t[0], t[3], t[1], t[4], t[2], t[5]);
                Point2D t1 = this.transform.transform(new Point2D.Float(this.cx, this.cy), null);
                Point2D t2 = this.transform.transform(new Point2D.Float(this.cx + this.r, this.cy), null);
                this.cx = (float)t1.getX();
                this.cy = (float)t1.getY();
                this.r = (float)(t2.getX() - t1.getX());
            }
        }
    }

    class RadialGradientPaint
    implements Paint {
        float cx;
        float cy;
        float radius;
        float[] offset;
        int[] color;
        int count;
        float opacity;

        public RadialGradientPaint(float cx, float cy, float radius, float[] offset, int[] color, int count, float opacity) {
            this.cx = cx;
            this.cy = cy;
            this.radius = radius;
            this.offset = offset;
            this.color = color;
            this.count = count;
            this.opacity = opacity;
        }

        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            return new RadialGradientContext();
        }

        public int getTransparency() {
            return 3;
        }

        public class RadialGradientContext
        implements PaintContext {
            int ACCURACY = 5;

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            public Raster getRaster(int x, int y, int w, int h) {
                WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
                int span = (int)RadialGradientPaint.this.radius * this.ACCURACY;
                int[][] interp = new int[span][4];
                int prev = 0;
                int i = 1;
                while (i < RadialGradientPaint.this.count) {
                    int c0 = RadialGradientPaint.this.color[i - 1];
                    int c1 = RadialGradientPaint.this.color[i];
                    int last = (int)(RadialGradientPaint.this.offset[i] * (float)(span - 1));
                    int j = prev;
                    while (j <= last) {
                        float btwn = PApplet.norm(j, prev, last);
                        interp[j][0] = (int)PApplet.lerp(c0 >> 16 & 0xFF, c1 >> 16 & 0xFF, btwn);
                        interp[j][1] = (int)PApplet.lerp(c0 >> 8 & 0xFF, c1 >> 8 & 0xFF, btwn);
                        interp[j][2] = (int)PApplet.lerp(c0 & 0xFF, c1 & 0xFF, btwn);
                        interp[j][3] = (int)(PApplet.lerp(c0 >> 24 & 0xFF, c1 >> 24 & 0xFF, btwn) * RadialGradientPaint.this.opacity);
                        ++j;
                    }
                    prev = last;
                    ++i;
                }
                int[] data = new int[w * h * 4];
                int index = 0;
                int j = 0;
                while (j < h) {
                    int i2 = 0;
                    while (i2 < w) {
                        float distance = PApplet.dist(RadialGradientPaint.this.cx, RadialGradientPaint.this.cy, x + i2, y + j);
                        int which = PApplet.min((int)(distance * (float)this.ACCURACY), interp.length - 1);
                        data[index++] = interp[which][0];
                        data[index++] = interp[which][1];
                        data[index++] = interp[which][2];
                        data[index++] = interp[which][3];
                        ++i2;
                    }
                    ++j;
                }
                raster.setPixels(0, 0, w, h, data);
                return raster;
            }
        }
    }
}

