import processing.core.*; 
import processing.xml.*; 

import sms.*; 
import ddf.minim.*; 
import ddf.minim.analysis.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class CAVEHUNTER extends PApplet {






int sectionNum = 20;
int sectionCount;
int sectionIndex;
int prevSectionIndex;

int obstacleNum = 10;
int obstacleCount;
int obstacleIndex;

int pointNum = 10;
int pointCount;
int pointIndex;

int collision=0;
int score=0;
boolean play=false;
boolean go=false;

float generalSpeed=5;

CaveSection[] caveSections = new CaveSection[sectionNum];
Obstacle01[] obstacles01 = new Obstacle01[obstacleNum];
Point[] points = new Point[pointNum];
Ship ship;
Score gameScore;
Start start;
GameOver gameOver;
StartScreen startScreen;

float anschlussX,anschlussYo,anschlussYu;
int sectionId;

////////////////////////////////////////////////////////////////////// Sound
Minim minim;
AudioPlayer gameSound;
AudioPlayer introSound;
AudioPlayer boom;
AudioPlayer kasching;

///////////////////////////////////////////////////////////////////////////////////// SETUP

public void setup(){
  size(800,450);
  background(0);
  smooth();
  frameRate(30);

  startScreen = new StartScreen();
  
  ////////////////////////////////////////////////////////////////////// Sound
  minim = new Minim(this);
  introSound = minim.loadFile("introSound.mp3", 512);
  
  introSound.play();
}

///////////////////////////////////////////////////////////////////////////////////////// DRAW

public void draw(){
  background(0);

  if(play){
    start.update();
    generateCave();
    ship.update();
    gameScore.update();
    
    if(frameCount%3==0 && !go){
      score++;
    }

    if(collision>=5){
      gameOver.update();
    }
  }
  else{
    startScreen.update();
  }
}

public void keyReleased() {
  if(key==CODED){
    if(go==true && keyCode==RIGHT){
      reset();
    }
    else if(!play){
      play=true;
      reset();
      introSound.close();
    }
  }
}





class CaveSection{
  int id;
  float pos;
  float x1,x2,yo1,yo2,yu1,yu2;
  int farbe;
  boolean hitTest;
  float hitBorderO,hitBorderU;
  float winkel;

  CaveSection(float _x1,float _yo1,float _yu1,int _id){
    x1=_x1;
    yo1=_yo1;
    yu1=_yu1;
    id=_id;

    x2=x1+random(100,150);
    yo2=yo1+random(-50,50);
    if(yo2<0) yo2=0;
    yu2=yo2+random(30,150);
    if(yu2>height){
      yo2-=yu2-height;
      yu2=height;
    }

    hitTest=false;

    if(yo1>yo2) hitBorderO=yo1;
    else hitBorderO=yo2;

    if(yu1<yu2) hitBorderU=yu1;
    else hitBorderU=yu2;

    farbe=255;

  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////// positionieren
  public void positionieren(){
    pos-=generalSpeed;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////// hitTest
 public boolean hitTest(){
    if(ship.x-ship.sizeX/2 >= pos+x1 && ship.x+ship.sizeX/2<=pos+x2){
      if(ship.y-ship.sizeY/2<hitBorderO){
        if(yo1>yo2){
          winkel=winkelBerechnung(pos+x2,yo2,pos+x1,yo1,ship.x-ship.sizeX/2,ship.y-ship.sizeY/2);
        }
        else{
          winkel=winkelBerechnung(pos+x1,yo1,pos+x2,yo2,ship.x+ship.sizeX/2,ship.y-ship.sizeY/2)*(-1);
        }
      }

      if(ship.y+ship.sizeY/2>hitBorderU){
        if(yu1<yu2){
          winkel=winkelBerechnung(ship.x-ship.sizeX/2,ship.y+ship.sizeY/2,pos+x1,yu1,pos+x2,yu2);
        }
        else{
          winkel=winkelBerechnung(pos+x1,yu1,pos+x2,yu2,ship.x+ship.sizeX/2,ship.y+ship.sizeY/2);
        }
      }
      //println(winkel);
      if (winkel<0 && hitTest==false){
        hitTest=true;
      }
    }
    return hitTest;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////// zeichnen
  public void zeichnen(){
    noStroke();
    fill(farbe);
    quad(pos+x1,yo1,pos+x2,yo2,pos+x2,yu2,pos+x1,yu1);
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////// update
  public void update(){
    if(collision<5){
    positionieren();
    }
    zeichnen();
  }
}






/////////////////////////////////////////////////////////////////////////////////////// H\u00f6hle generieren

public void generateCave(){
  if(abs(caveSections[prevSectionIndex].pos)+width >= anschlussX){
    caveSections[sectionIndex] = new CaveSection(width,anschlussYo,anschlussYu,sectionId);

    generateObstacle(anschlussYo,anschlussYu);
    generatePoint(anschlussYo,anschlussYu);

    anschlussX=caveSections[sectionIndex].x2-generalSpeed;
    anschlussYo=caveSections[sectionIndex].yo2;
    anschlussYu=caveSections[sectionIndex].yu2;

    sectionId++;
    if(sectionCount<sectionNum) sectionCount++;

    prevSectionIndex=sectionIndex;

    sectionIndex++;
    if(sectionIndex>=sectionNum)sectionIndex=0;
  }

  for(int i=0;i<sectionCount;i++){
    caveSections[i].update();
    if(caveSections[i].hitTest()==true && collision==0){
      collision=1;
    }
  }

  for(int i=0; i<obstacleCount;i++){
    obstacles01[i].update();
  }

  for(int i=0; i<pointCount;i++){
    points[i].update();
  }
}


/////////////////////////////////////////////////////////////////////////////////////// Hindernisse generieren

public void generateObstacle(float y1,float y2){
  float wahrsch = random(10);
  if(y2-y1 > ship.sizeY+10 && wahrsch>5){
    obstacles01[obstacleIndex] = new Obstacle01(width,y1,y2-y1);
    obstacleIndex++;
    if(obstacleIndex>=obstacleNum) obstacleIndex=0;
    if(obstacleCount<obstacleNum)obstacleCount++;
  }
}


/////////////////////////////////////////////////////////////////////////////////////// Punkte generieren

public void generatePoint(float y1,float y2){
  float wahrsch = random(10);
  if(wahrsch>5){
    points[pointIndex] = new Point(width,y1,y2-y1);
    pointIndex++;
    if(pointIndex>=obstacleNum) pointIndex=0;
    if(pointCount<obstacleNum)pointCount++;
  }
}


/////////////////////////////////////////////////////////////////////////////////////// Winkelberechnung

public float winkelBerechnung(float x1,float y1,float x2,float y2,float x3,float y3){

  PVector a=new PVector(x1-x2,y1-y2);
  PVector n=new PVector(-1*a.y,a.x);

  float x4=x2+n.x;
  float y4=y2+n.y;
  float cosinus=((x4-x2)*(x3-x2)+(y4-y2)*(y3-y2))/(dist(x2,y2,x4,y4)*dist(x2,y2,x3,y3));

  return cosinus;
}


////////////////////////////////////////////////////////////////////////////////////// Explode

public void explode(float _kX,float _kY){
  float r;
  float x,y;
  float kX=_kX;
  float kY=_kY;

  fill(255,0,0);
  noStroke();

  beginShape();
  for(int i=0;i<12;i++){
    if(i%2==0){
      r=random(40,50);
    }
    else{
      r=random(10,20);
    }
    x=kX+cos(radians(i*random(28,32)))*r;
    y=kY+sin(radians(i*random(28,32)))*r;
    vertex(x, y);
  }
  endShape(CLOSE);

  if(collision==1){
    boom = minim.loadFile("explode.mp3", 512);
    boom.play();
    gameSound.close();
  }
}


////////////////////////////////////////////////////////////////////////////////////// Reset

public void reset(){
  score=0;
  collision=0;
  go=false;

  obstacleCount=0;
  obstacleIndex=0;
  pointCount=0;
  pointIndex=0;

  sectionId=0;
  sectionCount=0;
  sectionIndex=0;
  prevSectionIndex=0;
  anschlussX=width;
  anschlussYo=height/2-30;
  anschlussYu=height/2+30;

  int tiltSetup[] = Unimotion.getSMSArray();
  ship = new Ship(tiltSetup);
  gameScore = new Score();
  start = new Start();
  gameOver = new GameOver();

  caveSections[sectionIndex] = new CaveSection(anschlussX,anschlussYo,anschlussYu,sectionId);
  anschlussX=caveSections[sectionIndex].x2-generalSpeed;
  anschlussYo=caveSections[sectionIndex].yo2;
  anschlussYu=caveSections[sectionIndex].yu2;
  sectionId++;
  sectionCount++;
  sectionIndex++;

  gameSound = minim.loadFile("bubbles.mp3", 512);
  boom = minim.loadFile("explode.mp3", 512);
  kasching = minim.loadFile("kasching.mp3", 512);

  gameSound.play();
  gameSound.loop(99);
}







class GameOver{

  PFont font;
  PFont fontScore;
  PFont fontReplay;
  boolean showReplay=false;

  GameOver(){
    font = loadFont("AndaleMono-60.vlw");
    fontScore = loadFont("AndaleMono-30.vlw");
    fontReplay = loadFont("AndaleMono-20.vlw");
  }
  public void zeichnen(){
    fill(255,0,0);
    textFont(font);
    textAlign(CENTER);
    text("GAME OVER",width/2,height/2+22);

    fill(0,255,0);
    textFont(fontScore);
    textAlign(CENTER);
    text("SCORE: "+score,width/2,height/2+70);

    if(frameCount % 30==0){
      if(showReplay)showReplay=false;
      else showReplay=true;
    }
    if(showReplay){
      fill(114,0,255,150);
      noStroke();
      rectMode(CENTER);
      rect(width/2,height/2+114,400,30);
      fill(255);
      textFont(fontReplay);
      textAlign(CENTER);
      text("* Press 'RIGHT' to play again! *",width/2,height/2+120);
    }


    if(go==false){
      go=true;
    }
  }

  public void update(){
    zeichnen();
  }
}



class Obstacle01{
  float posX,posY;
  float range;
  float speed;
  int dir;
  float x,y;
  float angle;
  float s; //s is for size

  Obstacle01(float _posX,float _posY,float _range){
    posX=_posX;
    posY=_posY+_range/2;
    range=_range;
    s=8;
    speed=generalSpeed;
    dir=PApplet.parseInt(random(2));
    if(dir<1 || dir==2){
      dir=-1;
    }

    angle=random(360);
  }

  public void positionieren(){
    posX-=generalSpeed;
    
    x=posX+cos(radians(angle))*(range/2);
    y=posY+sin(radians(angle))*(range/2);
    angle+=speed*dir;
    if(angle>360)angle-=360;
    else if(angle<-360)angle+=360;
  }

  public void hitTest(){
    if(abs(x-ship.x) < s/2+ship.sizeX/2 && abs(y-ship.y) < s/2+ship.sizeY/2 && collision==0){
      collision=1;
    }
  }

  public void zeichnen(){
    noStroke();
    fill(255,0,0);
    rectMode(CENTER);
    rect(x,y,s,s);
  }

  public void update(){
    if(collision<5){
      hitTest();
      positionieren();
    }
    zeichnen();
  }
}


class Point{
  float posX,posY;
  float range;
  float speed;
  float y;
  float angle;
  float s; //s is for size
  int value;
  int farbe;
  boolean hit=false;

  Point(float _posX,float _posY,float _range){
    posX=_posX;
    posY=_posY+_range/2;
    range=_range;
    s=10;
    speed=generalSpeed;

    angle=random(360);

    value=PApplet.parseInt(random(3))+1;
    value*=100;
    switch(value) {
    case 100: 
      farbe = color(150,255,0);
      break;
    case 200: 
      farbe = color(255,220,0);
      break;
    case 300: 
      farbe = color(114,0,255);
      break;
    }
  }

  public void positionieren(){
    posX-=generalSpeed;
    y=posY+sin(radians(angle))*(range/2);
    angle+=speed;
    if(angle>360)angle-=360;
  }

  public void hitTest(){
    if(abs(posX-ship.x) < s/2+ship.sizeX/2 && abs(y-ship.y) < s/2+ship.sizeY/2 && hit==false){
      score+=value;
      hit=true;
      kasching = minim.loadFile("kasching.mp3", 512);
      kasching.play();
    }
  }

  public void zeichnen(){
    stroke(farbe);
    strokeWeight(2);
    noFill();
    ellipse(posX,y,s,s);
  }

  public void update(){
    if(hit==false){
      if(collision<5){
        hitTest();
        positionieren();
      }
      zeichnen();
    }
  }
}





class Score{
  float x,y;
  PFont font;

  Score(){
    x=width-10;
    y=20;
    
    font = loadFont("AndaleMono-14.vlw");
  }

  public void zeichnen(){
    fill(0,255,0);
    textFont(font);
    textAlign(RIGHT);
    text("score: "+score, x, y);
  }

  public void update(){
    zeichnen();
  }
}




class Ship{
  float x,y;
  float targetX,targetY;
  float sizeX=10;
  float sizeY=5;
  float speed=2;
  int[] tiltAusgleich;
  int[] tilt = new int[2];
  int[] values;

  Ship(int[] _tiltAusgleich){
    x=targetX=width/2;
    y=targetY=height/2;

    tiltAusgleich=_tiltAusgleich;
  }

  public void positionieren(){
    values=Unimotion.getSMSArray();

    tilt[0]=(values[0]-tiltAusgleich[0]);
    tilt[1]=(values[1]-tiltAusgleich[1]);
    
    
    targetX=map(tilt[0],-20,20,0,width);
    targetY=map(tilt[1],20,-20,0,height);
    
    x+=tilt[0]/5;
    y-=tilt[1]/5;

    /*
    if(keyPressed){
     if (key == CODED) {
     if (keyCode == UP) {
     y-=speed;
     } 
     else if (keyCode == DOWN) {
     y+=speed;
     }
     else if (keyCode == RIGHT) {
     x+=speed;
     }
     else if (keyCode == LEFT) {
     x-=speed;
     }
     }
     }
     */

    if(x-sizeX/2<0 || x+sizeX/2>width){
      if(collision==0){
        collision=1;
      }
    }
  }

  public void zeichnen(){
    if(collision==0){
      noStroke();
      fill(72,180,255);
      rectMode(CENTER);
      rect(x,y,sizeX,sizeY);
    }
    else if(collision>0 && collision<5){
      explode(x,y);
      collision++;
    }
  }

  public void update(){
    if(collision<5){
      positionieren();
      zeichnen();
    }
  }
}












class Start{
  float x,y;
  float sizeY;

  Start(){
    sizeY=60;
    x=0;
    y=height/2-sizeY/2;
  }

  public void positionieren(){
    x-=generalSpeed;
  }

  public void hitTest(){
    if(ship.y-ship.sizeY/2<y || ship.y+ship.sizeY/2 > y+sizeY){
      if(collision==0 && ship.x-ship.sizeX<x+width){
        collision=1;
      }
    }
  }

  public void zeichnen(){
    noStroke();
    fill(255);
    rectMode(CORNER);
    rect(x,y,width,sizeY);
  }

  public void update(){
    if(x>-width&&collision<5){
      hitTest();
      positionieren();
    }
    zeichnen();
  }
}



class StartScreen{

  PImage pic;
  PFont font;
  boolean show=true;

  StartScreen(){

    font = loadFont("AndaleMono-30.vlw");
    pic = loadImage("startScreen.png");
  }

  public void zeichnen(){
    image(pic,0,0);
    
    if(frameCount % 30==0){
      if(show)show=false;
      else show=true;
    }
    if(show){
      fill(255);
      textFont(font);
      textAlign(CENTER);
      text("* Press 'RIGHT' to play! *",width/2,height-50);
    }
  }

  public void update(){
    zeichnen();
  }
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--present", "--bgcolor=#666666", "--stop-color=#cccccc", "CAVEHUNTER" });
  }
}
