
/////////////////////////////////////////////////////////////////////////////////////// Höhle generieren

void generateCave(){
  if(abs(caveSections[prevSectionIndex].pos)+width >= anschlussX){
    caveSections[sectionIndex] = new CaveSection(width,anschlussYo,anschlussYu,sectionId);

    generateObstacle(anschlussYo,anschlussYu);
    generatePoint(anschlussYo,anschlussYu);

    anschlussX=caveSections[sectionIndex].x2-generalSpeed;
    anschlussYo=caveSections[sectionIndex].yo2;
    anschlussYu=caveSections[sectionIndex].yu2;

    sectionId++;
    if(sectionCount<sectionNum) sectionCount++;

    prevSectionIndex=sectionIndex;

    sectionIndex++;
    if(sectionIndex>=sectionNum)sectionIndex=0;
  }

  for(int i=0;i<sectionCount;i++){
    caveSections[i].update();
    if(caveSections[i].hitTest()==true && collision==0){
      collision=1;
    }
  }

  for(int i=0; i<obstacleCount;i++){
    obstacles01[i].update();
  }

  for(int i=0; i<pointCount;i++){
    points[i].update();
  }
}


/////////////////////////////////////////////////////////////////////////////////////// Hindernisse generieren

void generateObstacle(float y1,float y2){
  float wahrsch = random(10);
  if(y2-y1 > ship.sizeY+10 && wahrsch>5){
    obstacles01[obstacleIndex] = new Obstacle01(width,y1,y2-y1);
    obstacleIndex++;
    if(obstacleIndex>=obstacleNum) obstacleIndex=0;
    if(obstacleCount<obstacleNum)obstacleCount++;
  }
}


/////////////////////////////////////////////////////////////////////////////////////// Punkte generieren

void generatePoint(float y1,float y2){
  float wahrsch = random(10);
  if(wahrsch>5){
    points[pointIndex] = new Point(width,y1,y2-y1);
    pointIndex++;
    if(pointIndex>=obstacleNum) pointIndex=0;
    if(pointCount<obstacleNum)pointCount++;
  }
}


/////////////////////////////////////////////////////////////////////////////////////// Winkelberechnung

float winkelBerechnung(float x1,float y1,float x2,float y2,float x3,float y3){

  PVector a=new PVector(x1-x2,y1-y2);
  PVector n=new PVector(-1*a.y,a.x);

  float x4=x2+n.x;
  float y4=y2+n.y;
  float cosinus=((x4-x2)*(x3-x2)+(y4-y2)*(y3-y2))/(dist(x2,y2,x4,y4)*dist(x2,y2,x3,y3));

  return cosinus;
}


////////////////////////////////////////////////////////////////////////////////////// Explode

void explode(float _kX,float _kY){
  float r;
  float x,y;
  float kX=_kX;
  float kY=_kY;

  fill(255,0,0);
  noStroke();

  beginShape();
  for(int i=0;i<12;i++){
    if(i%2==0){
      r=random(40,50);
    }
    else{
      r=random(10,20);
    }
    x=kX+cos(radians(i*random(28,32)))*r;
    y=kY+sin(radians(i*random(28,32)))*r;
    vertex(x, y);
  }
  endShape(CLOSE);

  if(collision==1){
    boom = minim.loadFile("explode.mp3", 512);
    boom.play();
    gameSound.close();
  }
}


////////////////////////////////////////////////////////////////////////////////////// Reset

void reset(){
  score=0;
  collision=0;
  go=false;

  obstacleCount=0;
  obstacleIndex=0;
  pointCount=0;
  pointIndex=0;

  sectionId=0;
  sectionCount=0;
  sectionIndex=0;
  prevSectionIndex=0;
  anschlussX=width;
  anschlussYo=height/2-30;
  anschlussYu=height/2+30;

  int tiltSetup[] = Unimotion.getSMSArray();
  ship = new Ship(tiltSetup);
  gameScore = new Score();
  start = new Start();
  gameOver = new GameOver();

  caveSections[sectionIndex] = new CaveSection(anschlussX,anschlussYo,anschlussYu,sectionId);
  anschlussX=caveSections[sectionIndex].x2-generalSpeed;
  anschlussYo=caveSections[sectionIndex].yo2;
  anschlussYu=caveSections[sectionIndex].yu2;
  sectionId++;
  sectionCount++;
  sectionIndex++;

  gameSound = minim.loadFile("bubbles.mp3", 512);
  boom = minim.loadFile("explode.mp3", 512);
  kasching = minim.loadFile("kasching.mp3", 512);

  gameSound.play();
  gameSound.loop(99);
}







